'use client';

import React from 'react';
import {
    Box,
    Container,
    Typography,
    Grid,
    Card,
    CardContent,
    Avatar,
    Button,
} from '@mui/material';
import { People, TrendingUp, Security, EmojiEvents } from '@mui/icons-material';
import Header from '@/components/Header';
import Footer from '@/components/Footer';
import { stats } from '@/data/mockData';

export default function AboutPage() {
    const team = [
        {
            name: 'Alex Johnson',
            role: 'CEO & Founder',
            avatar: 'https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=200&h=200&fit=crop',
        },
        {
            name: 'Sarah Williams',
            role: 'Head of Operations',
            avatar: 'https://images.unsplash.com/photo-1494790108377-be9c29b29330?w=200&h=200&fit=crop',
        },
        {
            name: 'Michael Chen',
            role: 'Head of Technology',
            avatar: 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=200&h=200&fit=crop',
        },
        {
            name: 'Emma Davis',
            role: 'Head of Marketing',
            avatar: 'https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=200&h=200&fit=crop',
        },
    ];

    const values = [
        {
            icon: <People sx={{ fontSize: 40 }} />,
            title: 'Community First',
            description: 'We believe in building a strong community of freelancers and clients who support each other.',
        },
        {
            icon: <TrendingUp sx={{ fontSize: 40 }} />,
            title: 'Growth &amp; Innovation',
            description: 'Constantly evolving our platform to provide the best tools and opportunities for success.',
        },
        {
            icon: <Security sx={{ fontSize: 40 }} />,
            title: 'Trust & Security',
            description: 'Your security is our priority. We ensure safe transactions and protect your data.',
        },
        {
            icon: <EmojiEvents sx={{ fontSize: 40 }} />,
            title: 'Excellence',
            description: 'We strive for excellence in everything we do, from service quality to customer support.',
        },
    ];

    return (
        <>
            <Header />

            {/* Hero Section */}
            <Box
                sx={{
                    background: 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)',
                    color: 'white',
                    py: 10,
                }}
            >
                <Container maxWidth="md" sx={{ textAlign: 'center' }}>
                    <Typography variant="h2" fontWeight={700} gutterBottom>
                        About Us
                    </Typography>
                    <Typography variant="h5" sx={{ opacity: 0.9 }}>
                        Connecting talent with opportunity worldwide
                    </Typography>
                </Container>
            </Box>

            {/* Story Section */}
            <Container maxWidth="lg" sx={{ mt: 8, mb: 8 }}>
                <Grid container spacing={6} alignItems="center">
                    <Grid item xs={12} md={6}>
                        <Typography variant="h3" fontWeight={700} gutterBottom>
                            Our Story
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            Founded in 2019, our freelance marketplace was born from a simple idea: to create a platform where talented professionals could connect with businesses that need their skills, regardless of location.
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            What started as a small team with a big vision has grown into a thriving community of over 500,000 freelancers and thousands of satisfied clients worldwide. We've facilitated millions of successful projects and helped countless individuals build their dream careers.
                        </Typography>
                        <Typography variant="body1" sx={{ lineHeight: 1.8 }}>
                            Today, we continue to innovate and improve our platform, always keeping our community's needs at the forefront of everything we do.
                        </Typography>
                    </Grid>
                    <Grid item xs={12} md={6}>
                        <Box
                            component="img"
                            src="https://images.unsplash.com/photo-1522071820081-009f0129c71c?w=800&h=600&fit=crop"
                            alt="Team collaboration"
                            sx={{
                                width: '100%',
                                height: 400,
                                objectFit: 'cover',
                                borderRadius: 2,
                            }}
                        />
                    </Grid>
                </Grid>
            </Container>

            {/* Stats Section */}
            <Box sx={{ bgcolor: 'background.default', py: 8 }}>
                <Container maxWidth="lg">
                    <Grid container spacing={4}>
                        {stats.map((stat) => (
                            <Grid item xs={6} md={3} key={stat.label}>
                                <Card sx={{ textAlign: 'center', p: 3 }}>
                                    <Typography variant="h2" sx={{ fontSize: '3rem', mb: 1 }}>
                                        {stat.icon}
                                    </Typography>
                                    <Typography variant="h3" fontWeight={700} color="primary.main" gutterBottom>
                                        {stat.value}
                                    </Typography>
                                    <Typography variant="body1" color="text.secondary">
                                        {stat.label}
                                    </Typography>
                                </Card>
                            </Grid>
                        ))}
                    </Grid>
                </Container>
            </Box>

            {/* Values Section */}
            <Container maxWidth="lg" sx={{ mt: 8, mb: 8 }}>
                <Box sx={{ textAlign: 'center', mb: 6 }}>
                    <Typography variant="h3" fontWeight={700} gutterBottom>
                        Our Values
                    </Typography>
                    <Typography variant="h6" color="text.secondary">
                        The principles that guide everything we do
                    </Typography>
                </Box>
                <Grid container spacing={4}>
                    {values.map((value) => (
                        <Grid item xs={12} sm={6} md={3} key={value.title}>
                            <Card sx={{ height: '100%', textAlign: 'center', p: 3 }}>
                                <Box
                                    sx={{
                                        width: 80,
                                        height: 80,
                                        borderRadius: '50%',
                                        background: 'linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%)',
                                        display: 'flex',
                                        alignItems: 'center',
                                        justifyContent: 'center',
                                        margin: '0 auto 16px',
                                        color: 'white',
                                    }}
                                >
                                    {value.icon}
                                </Box>
                                <Typography variant="h6" fontWeight={600} gutterBottom>
                                    {value.title}
                                </Typography>
                                <Typography variant="body2" color="text.secondary">
                                    {value.description}
                                </Typography>
                            </Card>
                        </Grid>
                    ))}
                </Grid>
            </Container>

            {/* Team Section */}
            <Box sx={{ bgcolor: 'background.default', py: 8 }}>
                <Container maxWidth="lg">
                    <Box sx={{ textAlign: 'center', mb: 6 }}>
                        <Typography variant="h3" fontWeight={700} gutterBottom>
                            Meet Our Team
                        </Typography>
                        <Typography variant="h6" color="text.secondary">
                            The people behind the platform
                        </Typography>
                    </Box>
                    <Grid container spacing={4}>
                        {team.map((member) => (
                            <Grid item xs={12} sm={6} md={3} key={member.name}>
                                <Card sx={{ textAlign: 'center', p: 3 }}>
                                    <Avatar
                                        src={member.avatar}
                                        alt={member.name}
                                        sx={{ width: 120, height: 120, margin: '0 auto 16px' }}
                                    />
                                    <Typography variant="h6" fontWeight={600}>
                                        {member.name}
                                    </Typography>
                                    <Typography variant="body2" color="text.secondary">
                                        {member.role}
                                    </Typography>
                                </Card>
                            </Grid>
                        ))}
                    </Grid>
                </Container>
            </Box>

            {/* CTA Section */}
            <Container maxWidth="md" sx={{ mt: 8, mb: 8, textAlign: 'center' }}>
                <Typography variant="h3" fontWeight={700} gutterBottom>
                    Join Our Community
                </Typography>
                <Typography variant="h6" color="text.secondary" sx={{ mb: 4 }}>
                    Whether you're looking to hire or looking for work, we're here to help you succeed
                </Typography>
                <Box sx={{ display: 'flex', gap: 2, justifyContent: 'center' }}>
                    <Button variant="contained" size="large" href="/register">
                        Get Started
                    </Button>
                    <Button variant="outlined" size="large" href="/contact">
                        Contact Us
                    </Button>
                </Box>
            </Container>

            <Footer />
        </>
    );
}
