'use client';

import React, { useState } from 'react';
import { useRouter } from 'next/navigation';
import {
    Box,
    Container,
    Typography,
    TextField,
    Button,
    Card,
    CardContent,
    Link,
    Alert,
} from '@mui/material';
import { Email, ArrowBack } from '@mui/icons-material';
import Header from '@/components/Header';
import Footer from '@/components/Footer';

export default function ForgotPasswordPage() {
    const router = useRouter();
    const [email, setEmail] = useState('');
    const [error, setError] = useState('');
    const [success, setSuccess] = useState(false);

    const handleSubmit = (e) => {
        e.preventDefault();
        if (!email) {
            setError('Email is required');
        } else if (!/\S+@\S+\.\S+/.test(email)) {
            setError('Email is invalid');
        } else {
            setError('');
            setSuccess(true);
            // Simulate API call
            console.log('Password reset requested for:', email);
        }
    };

    return (
        <>
            <Header />

            <Box
                sx={{
                    minHeight: 'calc(100vh - 200px)',
                    display: 'flex',
                    alignItems: 'center',
                    background: 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)',
                    py: 8,
                }}
            >
                <Container maxWidth="sm">
                    <Card>
                        <CardContent sx={{ p: 4 }}>
                            <Box sx={{ textAlign: 'center', mb: 4 }}>
                                <Email sx={{ fontSize: 60, color: 'primary.main', mb: 2 }} />
                                <Typography variant="h4" fontWeight={700} gutterBottom>
                                    Forgot Password?
                                </Typography>
                                <Typography variant="body1" color="text.secondary">
                                    No worries! Enter your email and we'll send you reset instructions.
                                </Typography>
                            </Box>

                            {success ? (
                                <Alert severity="success" sx={{ mb: 3 }}>
                                    Password reset link has been sent to your email. Please check your inbox.
                                </Alert>
                            ) : (
                                <form onSubmit={handleSubmit}>
                                    <TextField
                                        fullWidth
                                        label="Email Address"
                                        type="email"
                                        value={email}
                                        onChange={(e) => {
                                            setEmail(e.target.value);
                                            setError('');
                                        }}
                                        error={!!error}
                                        helperText={error}
                                        sx={{ mb: 3 }}
                                    />

                                    <Button
                                        type="submit"
                                        variant="contained"
                                        size="large"
                                        fullWidth
                                        sx={{ mb: 2 }}
                                    >
                                        Send Reset Link
                                    </Button>
                                </form>
                            )}

                            <Button
                                startIcon={<ArrowBack />}
                                onClick={() => router.push('/login')}
                                fullWidth
                            >
                                Back to Login
                            </Button>
                        </CardContent>
                    </Card>
                </Container>
            </Box>

            <Footer />
        </>
    );
}
