'use client';

import React, { Suspense } from 'react';
import { useRouter, useSearchParams } from 'next/navigation';
import {
    Box,
    Container,
    Typography,
    Card,
    CardContent,
    Button,
    Divider,
    List,
    ListItem,
    ListItemIcon,
    ListItemText,
} from '@mui/material';
import {
    CheckCircle,
    Email,
    AccessTime,
    Download,
    Home,
} from '@mui/icons-material';
import Header from '@/components/Header';
import Footer from '@/components/Footer';

export const dynamic = 'force-dynamic';

function OrderConfirmationContent() {
    const router = useRouter();
    const searchParams = useSearchParams();
    const orderId = searchParams.get('orderId') || '12345';

    return (
        <>
            <Header />

            <Container maxWidth="md" sx={{ mt: 8, mb: 8 }}>
                <Card>
                    <CardContent sx={{ p: 6, textAlign: 'center' }}>
                        <Box
                            sx={{
                                width: 80,
                                height: 80,
                                borderRadius: '50%',
                                background: 'linear-gradient(135deg, #10b981 0%, #059669 100%)',
                                display: 'flex',
                                alignItems: 'center',
                                justifyContent: 'center',
                                margin: '0 auto 24px',
                            }}
                        >
                            <CheckCircle sx={{ fontSize: 50, color: 'white' }} />
                        </Box>

                        <Typography variant="h3" fontWeight={700} gutterBottom>
                            Order Confirmed!
                        </Typography>
                        <Typography variant="h6" color="text.secondary" sx={{ mb: 4 }}>
                            Thank you for your order
                        </Typography>

                        <Box
                            sx={{
                                bgcolor: 'background.default',
                                p: 3,
                                borderRadius: 2,
                                mb: 4,
                            }}
                        >
                            <Typography variant="body2" color="text.secondary" gutterBottom>
                                Order Number
                            </Typography>
                            <Typography variant="h5" fontWeight={700}>
                                #{orderId}
                            </Typography>
                        </Box>

                        <Divider sx={{ my: 4 }} />

                        <Typography variant="h6" fontWeight={600} gutterBottom sx={{ textAlign: 'left' }}>
                            What happens next?
                        </Typography>

                        <List>
                            <ListItem>
                                <ListItemIcon>
                                    <Email color="primary" />
                                </ListItemIcon>
                                <ListItemText
                                    primary="Confirmation Email Sent"
                                    secondary="Check your inbox for order details and receipt"
                                />
                            </ListItem>
                            <ListItem>
                                <ListItemIcon>
                                    <AccessTime color="primary" />
                                </ListItemIcon>
                                <ListItemText
                                    primary="Freelancer Will Start Working"
                                    secondary="You'll receive a notification when work begins"
                                />
                            </ListItem>
                            <ListItem>
                                <ListItemIcon>
                                    <CheckCircle color="primary" />
                                </ListItemIcon>
                                <ListItemText
                                    primary="Track Your Order"
                                    secondary="Monitor progress in your dashboard"
                                />
                            </ListItem>
                        </List>

                        <Divider sx={{ my: 4 }} />

                        <Box sx={{ display: 'flex', gap: 2, justifyContent: 'center', flexWrap: 'wrap' }}>
                            <Button
                                variant="contained"
                                size="large"
                                startIcon={<Home />}
                                onClick={() => router.push('/dashboard')}
                            >
                                Go to Dashboard
                            </Button>
                            <Button
                                variant="outlined"
                                size="large"
                                startIcon={<Download />}
                            >
                                Download Invoice
                            </Button>
                        </Box>

                        <Typography variant="body2" color="text.secondary" sx={{ mt: 4 }}>
                            Need help? Contact our{' '}
                            <Button
                                onClick={() => router.push('/contact')}
                                sx={{ textTransform: 'none', p: 0, minWidth: 'auto' }}
                            >
                                support team
                            </Button>
                        </Typography>
                    </CardContent>
                </Card>
            </Container>

            <Footer />
        </>
    );
}

export default function OrderConfirmationPage() {
    return (
        <Suspense fallback={<div>Loading...</div>}>
            <OrderConfirmationContent />
        </Suspense>
    );
}
