'use client';

import React from 'react';
import { Box, Container, Typography, Paper, Divider } from '@mui/material';
import Header from '@/components/Header';
import Footer from '@/components/Footer';

export default function PrivacyPage() {
    return (
        <>
            <Header />

            <Box sx={{ bgcolor: 'background.default', py: 8 }}>
                <Container maxWidth="md">
                    <Paper sx={{ p: 6 }}>
                        <Typography variant="h3" fontWeight={700} gutterBottom>
                            Privacy Policy
                        </Typography>
                        <Typography variant="body2" color="text.secondary" gutterBottom>
                            Last updated: December 6, 2024
                        </Typography>

                        <Divider sx={{ my: 4 }} />

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            1. Information We Collect
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            We collect information you provide directly to us, including your name, email address, profile information, payment information, and any other information you choose to provide. We also collect information about your use of our services, including transaction history, messages, and service interactions.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            2. How We Use Your Information
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            We use the information we collect to: provide, maintain, and improve our services; process transactions and send related information; send you technical notices and support messages; respond to your comments and questions; communicate with you about products, services, and events; and monitor and analyze trends and usage.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            3. Information Sharing
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            We do not sell your personal information. We may share your information with: service providers who perform services on our behalf; other users as necessary to provide our services; law enforcement or regulatory authorities when required by law; and with your consent or at your direction.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            4. Data Security
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            We implement appropriate technical and organizational measures to protect your personal information against unauthorized access, alteration, disclosure, or destruction. However, no internet transmission is completely secure, and we cannot guarantee absolute security.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            5. Cookies and Tracking
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            We use cookies and similar tracking technologies to collect information about your browsing activities. You can control cookies through your browser settings, but disabling cookies may affect your ability to use certain features of our platform.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            6. Your Rights
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            You have the right to: access your personal information; correct inaccurate information; delete your information; object to processing of your information; and export your data. To exercise these rights, please contact us at privacy@freelancemarketplace.com.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            7. Data Retention
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            We retain your personal information for as long as necessary to provide our services, comply with legal obligations, resolve disputes, and enforce our agreements. When we no longer need your information, we will securely delete or anonymize it.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            8. International Data Transfers
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            Your information may be transferred to and processed in countries other than your country of residence. We ensure appropriate safeguards are in place to protect your information in accordance with this Privacy Policy.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            9. Children's Privacy
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            Our services are not intended for children under 18 years of age. We do not knowingly collect personal information from children. If you believe we have collected information from a child, please contact us immediately.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            10. Changes to Privacy Policy
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            We may update this Privacy Policy from time to time. We will notify you of any material changes by posting the new policy on this page and updating the "Last updated" date.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            11. Contact Us
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            If you have any questions about this Privacy Policy, please contact us at privacy@freelancemarketplace.com or write to us at: 123 Business St, San Francisco, CA 94107.
                        </Typography>
                    </Paper>
                </Container>
            </Box>

            <Footer />
        </>
    );
}
