'use client';

import React from 'react';
import { Box, Container, Typography, Paper, Divider } from '@mui/material';
import Header from '@/components/Header';
import Footer from '@/components/Footer';

export default function TermsPage() {
    return (
        <>
            <Header />

            <Box sx={{ bgcolor: 'background.default', py: 8 }}>
                <Container maxWidth="md">
                    <Paper sx={{ p: 6 }}>
                        <Typography variant="h3" fontWeight={700} gutterBottom>
                            Terms & Conditions
                        </Typography>
                        <Typography variant="body2" color="text.secondary" gutterBottom>
                            Last updated: December 6, 2024
                        </Typography>

                        <Divider sx={{ my: 4 }} />

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            1. Acceptance of Terms
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            By accessing and using this freelance marketplace platform, you accept and agree to be bound by the terms and provision of this agreement. If you do not agree to these Terms & Conditions, please do not use our services.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            2. User Accounts
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            You are responsible for maintaining the confidentiality of your account and password. You agree to accept responsibility for all activities that occur under your account. You must notify us immediately of any unauthorized use of your account.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            3. Services
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            Our platform provides a marketplace for freelancers to offer their services and for clients to purchase those services. We facilitate the connection between freelancers and clients but are not responsible for the quality, safety, or legality of the services provided.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            4. Payments and Fees
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            All payments are processed through our secure payment system. We charge a service fee of 10% on all transactions. Freelancers agree to pay this fee for each completed transaction. Clients agree to pay the full amount including service fees at the time of purchase.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            5. Refunds and Disputes
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            If you are not satisfied with a service, you may request revisions as specified in the service package. If the issue cannot be resolved, you may open a dispute within 14 days of delivery. Our team will review the case and make a fair decision.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            6. Intellectual Property
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            Unless otherwise specified, all work delivered through our platform becomes the property of the client upon full payment. Freelancers retain the right to display work in their portfolio unless otherwise agreed.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            7. Prohibited Activities
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            Users are prohibited from: using the platform for illegal activities, attempting to circumvent our fee structure, harassing other users, posting inappropriate content, or violating intellectual property rights.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            8. Limitation of Liability
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            We are not liable for any indirect, incidental, special, consequential, or punitive damages resulting from your use of the platform. Our total liability shall not exceed the amount of fees paid by you in the past 12 months.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            9. Changes to Terms
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            We reserve the right to modify these terms at any time. We will notify users of any material changes via email or platform notification. Continued use of the platform after changes constitutes acceptance of the new terms.
                        </Typography>

                        <Typography variant="h5" fontWeight={600} gutterBottom sx={{ mt: 4 }}>
                            10. Contact Information
                        </Typography>
                        <Typography variant="body1" paragraph sx={{ lineHeight: 1.8 }}>
                            If you have any questions about these Terms & Conditions, please contact us at support@freelancemarketplace.com.
                        </Typography>
                    </Paper>
                </Container>
            </Box>

            <Footer />
        </>
    );
}
